CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_orc_pag_pix') THEN 
        CREATE TABLE est_orc_pag_pix (
		    cd_emp int not null default 0,
            cd_filial int not null default 0,
			cd_orc int not null default 0,
            cd_orc_pag_pix int not null,
			cd_orc_pag int not null,
			nr_transacao text not null,
			cd_banco varchar(10) not null,
			cnpj_adquirente varchar(14),
			CONSTRAINT est_orc_pag_pix_pkey PRIMARY KEY (cd_emp, cd_orc, cd_filial, cd_orc_pag_pix),
			CONSTRAINT est_orc_pag_pix_fkey FOREIGN KEY (cd_emp, cd_filial, cd_orc, cd_orc_pag) REFERENCES public.est_orc_pag(cd_emp, cd_filial, cd_orc, cd_orc_pag) 
			ON DELETE CASCADE ON UPDATE CASCADE
		)
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA est_orc_pag_pix %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();